/*
 * Micro Focus hover styles script
 *
 * Copyright (C) 2011, 2012 Micro Focus.
 * All rights reserved.
 */

// Apply welcome page row mouse over styles
function mf_welcomeRowMouseOver(rowId) {
  mf_welcomeRowMouseHandler(rowId, 1);
}

// Apply welcome page row mouse out styles
function mf_welcomeRowMouseOut(rowId) {
  mf_welcomeRowMouseHandler(rowId, 0);
}

// Apply welcome page item mouse over styles
function mf_welcomeItemMouseOver(rowId) {
  mf_welcomeItemMouseHandler(rowId, 1);
}

// Apply welcome page item mouse out styles
function mf_welcomeItemMouseOut(rowId) {
  mf_welcomeItemMouseHandler(rowId, 0);
}

// Apply style changes to a row
function mf_welcomeRowMouseHandler(rowId, isAdd) {

  /* Find the row, and then the first <div> within it. */
  var baseRow = document.getElementById(rowId);
  var baseDiv = null;
  if (baseRow != null) {
    var baseDivs = baseRow.getElementsByTagName("div");
    if (baseDivs != null && baseDivs.length > 0)
      baseDiv = baseDivs[0];
  }

  /* Process styles on the <div>. */
  if (baseDiv != null) {
    mf_welcomeApplyClass(baseDiv, "welcomeRowHover", isAdd);
  }

  /* Find the inner table rows. */
  var innerRows = baseDiv.getElementsByTagName("tr");
  if (innerRows != null && innerRows.length == 2) {

    /* First row. */
    mf_welcomeApplyClass(innerRows[0], "welcomeRowTopHover", isAdd);

    /* Second row. */
    var innerCells = innerRows[1].getElementsByTagName("td");
    if (innerCells != null && innerCells.length == 2) {
      mf_welcomeApplyClass(innerCells[0], "welcomeRowIconHover", isAdd);
      mf_welcomeApplyClass(innerCells[1], "welcomeRowListHover", isAdd);
    }
  }
}

// Apply style changes to an item
function mf_welcomeItemMouseHandler(rowId, isAdd) {

  /* Find the item. */
  var baseItem = document.getElementById(rowId);
  if (baseItem != null) {
    mf_welcomeApplyClass(baseItem, "welcomeItemHover", isAdd);
  }
}

// Apply style changes to some HTML entity
function mf_welcomeApplyClass(element, className, isAdd) {
  if (element == null)
    return;

  var newClass = element.className;
  if (newClass == null)
    newClass = "";

  /* Find existing style. */
  var oldPos = newClass.indexOf(className);
  var oldLen = className.length;
  if (oldPos > 0) {
    --oldPos;
    ++oldLen;
  }

  /* Modify style. */
  if (isAdd) {
    if (oldPos < 0) {
      if (newClass.length > 0)
        newClass += " ";
      newClass += className;
    }
  } else {
    if (oldPos >= 0)
      newClass = newClass.substr(0, oldPos) + newClass.substr(oldPos + oldLen);
  }

  /* Apply new style. */
  element.className = newClass;

  /* Fix up background images. */
  if (isAdd) {
    if (className == "welcomeRowHover") {
      element.style.backgroundImage = mf_makeImageUrl("section_background_middle.gif", true);
    } else if (className == "welcomeRowTopHover") {
      element.style.backgroundImage = mf_makeImageUrl("section_background_top.gif", true);
    } else if (className == "welcomeRowIconHover") {
      element.style.backgroundImage = mf_makeImageUrl("section_background_bottom.gif", true);
    } else if (className == "welcomeRowListHover") {
      element.style.backgroundImage = mf_makeImageUrl("section_background_bottom.gif", true);
    }
  } else {
    if (className == "welcomeRowHover") {
      element.style.backgroundImage = "none";
    } else if (className == "welcomeRowTopHover") {
      element.style.backgroundImage = "none";
    } else if (className == "welcomeRowIconHover") {
      element.style.backgroundImage = "none";
    } else if (className == "welcomeRowListHover") {
      element.style.backgroundImage = "none";
    }
  }
}

function mf_welcomeInit() {

  // quit if this function has already been called
  if (typeof mf_welcomeInit.done != "undefined")
    return;

  // flag this function so we don't do the same thing twice
  mf_welcomeInit.done = true;

  // Get the bullet image URL. This will also do the URL initialization.
  var imgBullet = mf_makeImageUrl("bullet.png", true);

  // Get all the table cells with class nestedTableWelcomeCellList.
  var elemTDs = document.documentElement.getElementsByTagName("td");
  for (var i = 0; i < elemTDs.length; ++i) {
    if (elemTDs[i].className.indexOf("nestedTableWelcomeCellList") >= 0) {

      // Find all the lists within the cells.
      var elemULs = elemTDs[i].getElementsByTagName("ul");
      for (var j = 0; j < elemULs.length; ++j) {

        // Find all the list items.
        var elemLIs = elemULs[j].getElementsByTagName("li");
        for (var k = 0; k < elemLIs.length; ++k) {
        
          // Add a bullet image to each.
          elemLIs[k].style.backgroundImage = imgBullet;
        }
      }
    }
  }
}

/* Initialize the welcome page. */
mf_addBranding(mf_welcomeInit, "mf_welcomeInit");
